﻿using System;
using System.Collections.Generic;
using System.Text;
using CIA_CSS;
using CSS_User;

namespace IndianHealthService.BMXNet.CIA
{
    internal class BMXNetOverCiaLib : BMXNetLib
    {
        public static BMXNetLib OpenOn(ICSS_Session aCssSession,ICSS_User aCiaUser)
        {
            BMXNetOverCiaLib answer = new BMXNetOverCiaLib();
            answer.CiaSession= aCssSession;
            answer.CiaUser=aCiaUser;
            return answer;
        }

        private ICSS_User _ciaUser;

        public ICSS_User CiaUser
        {
            get { return _ciaUser; }
            set
            {
                _ciaUser = value;
                if (value != null)
                {
                    this.UserName = value.Name;
                    this.DUZ = value.Handle.ToString();
                }
            }
        }

        private ICSS_Session _ciaSession;

        public ICSS_Session CiaSession
        {
            get { return _ciaSession; }
            set { _ciaSession = value;}
        }
 

        protected override string SendReceiveString(string sendString, string multi)
        {
            return this.DecodeReceiveString(this.CiaSession.CallRPCText("VEN RPC^CIABMX", this.EncodeSendString(sendString, this.EncodeSendString(this.ADEEncryp(this.AppContext==null ? "BMXRPC" : this.AppContext),multi)))).Trim();
        }

        public override string GetLoginFacility()
        {
            throw new NotImplementedException();
        }

        public override bool IsConnected
        {
            get { return this.CiaSession != null;  }
        }
    }
}
